#ifndef SERVODRIVER_H
#define SERVODRIVER_H

#include <stdio.h>
#include <iostream>
#include <fstream>
#include <unistd.h>
#include <fcntl.h>
#include <termios.h>
#include <string>

using namespace std;
//Servo Driver Class
//This class interfaces with the Arduino Vex Servo Controller
//It can set the speed, set the speed limit, read the speed limit, and handle port IO
class servo_driver
{
public:
  servo_driver(); //Opens the default port "/dev/ttyUSB0"
  servo_driver(string pn); //Opens port specified by pn
  
  void serial_open(); //Used to open ports

  string get_port_name(); //Returns name of current port
  char get_motor1_speed();
  char get_motor2_speed();
  char get_motor1_limit();
  char get_motor2_limit();

  void set_motors(char m1, char m2);
  void set_motors(); //uses existing values

  void set_limits(char m1l, char m2l);
  void set_limits(); //uses existing values

  string get_limits(); //Returns speed limits, pulls new values from Arduino

  void set_motor1_speed(char m1);
  void set_motor2_speed(char m2);
  void set_motor1_limit(char m1l);
  void set_motor2_limit(char m2l);

private:
  string portname;
  ofstream port;
  char motor1_speed;
  char motor2_speed;
  char motor1_limit;
  char motor2_limit;
};

#endif
